                   [From the Hewlett-Packard PC Forum on CompuServe]
    
                             LINE QUALITY AND ACCURACY ---
                                     What They Are
                                And How to Achieve Them
    
    
    Plotter technical specifications often contain the terms 'line quality' and
    'accuracy'. This application note defines those terms, tells you how to
    find out your own plotter's capacity for precision, and suggests ways for
    achieving the best plots possible.
    
    This note is for people who
    
    1.need the most accurate plots possible --- such as for overlays.
    
    2.wish to learn more about getting the best looking plots possible.
    
    Line Quality --- What You Can See
    
    Good line quality is generally visible to the unaided eye: How good do the
    plotted lines look? Are the lines crisp rather than fuzzy? Smooth rather
    than jagged? Are corners precise? Do all the lines fit together without
    gaps or overlapping? The line quality of a plot is governed by specified
    and unspecified characteristics, both of which are discussed in this
    application note.
    
    Accuracy --- What You Can't See
    
    Accuracy errors are generally invisible to the unaided eye; but accuracy is
    important for certain types of precision plotting. This application note
    discusses Hewlett-Packard's definition of accuracy, and tells you how to go
    beyond the specification to get the best possible accuracy when you need
    to.
    
    What's in this Note
    
    This note contains the following sections:
    
    Section 1: What Is Line Quality?
    
    Section 2: How to Get the Best Line Quality
    
    Section 3: What Is Accuracy?
    
    Section 4: How to Get the Best Accuracy

    What Is Line Quality?
    --------------------
    
    Line quality --- how good the lines look --- is dependent upon both
    specified and unspecified factors:
    
    *  Repeatability (specified)
    *  Resolution (specified)
    *  Inking variation (unspecified)
    *  Trajectory errors (unspecified)
    
    Repeatability
    
    How closely does the plotter pen return to a previously plotted point?
    Repeatability is the ability to join new elements to previously plotted
    ones.  Every time a line is plotted to an endpoint, the exact location of
    that endpoint is different. The repeatability specification defines the
    maximum distance allowed between two nominally coincident endpoints. For
    example, a repeatability of 0.1mm means that all endpoints that are
    intended to be the same will lie within a circle of 0.1 mm in diameter.
    Repeatability is important because it affects appearance. The eye-appeal of
    a plot is greatly affected by repeatability, which determines the closure
    and shape of figures.
    
    Resolution
    
    There are two types of resolution that may be specified: mechanical
    resolution and addressable resolution. Mechanical resolution is the
    smallest move the plotter can physically make. Addressable resolution is
    the smallest move you can programmatically tell the plotter to make.
    
    Addressable resolution need not be finer than 0.025 mm (0.001 in) because
    the human eye cannot resolve distances of 0.025 mm or less. All HP plotters
    have at least 0.025 mm addressable resolution. Most HP plotters have even
    greater mechanical resolution, which allows them to employ high-gain
    digital servo technology, thus improving speed and acceleration. Higher
    mechanical resolution also improves line quality by enabling the pen to
    approach closer to the desired point.
    
    Other Components of Line Quality
    
    Line quality is dependent upon the above two specified aspects of plot
    quality, repeatability and resolution, as well as plotter characteristics
    which are not specified. These include inking variation, line width
    variation, and trajectory errors.
    
    Inking Variation
    
    Lines drawn at high speed can lose ink density. With magnification, this
    appears as un-inked spots within the inked line.
    
    Line Width Variation
    
    Because the flow of ink is generally not proportional to writing speed,
    unequal amounts of ink are applied per unit length. Therefore each end of a
    line, where the pen comes to rest, can be thicker than the middle, where
    the pen writes at top speed. This makes lettering and other fine detail
    appear 'scalloped'.

    Trajectory Errors
    
    No plotter draws perfectly straight lines. Plot quality is degraded to the
    extent that plotted lines stray from the ideal trajectory (pen path).
    Trajectory errors are generally produced by imperfections in the plotting
    mechanism, especially when stressed by high speed and acceleration. As
    described in the next section, you may be able to reduce pen speed and
    acceleration, either from the front panel, or by software commands.

    How to Get the Best Line Quality
    --------------------------------
    
    Use Polyester Film
    
    HP's double-matte, 3-mil film was specifically chosen to provide optimum
    performance when used with HP's refillable and disposable drafting pens.
    This finely coated, translucent medium minimizes pen and machine wear and
    maximizes line quality. Use this film when you need plots with distinct,
    continuous lines.
    
    Replace Worn Pens
    
    When a fiber-tip pen wears, the pen tip spreads out, increasing the line
    width.  When a drafting pen wears, the edges of the point become sharp,
    dislodging fibers and particles from drafting surfaces. To get the best
    line quality, you should replace worn pens.
    
    Use the Correct Ink
    
    If you are using refillable $MD rather than disposable $MD drafting pens,
    you may wish to experiment with different inks. Inks vary in viscosity,
    opacity, and drying time. Thick ink has more pigment, so it produces darker
    lines and flows more slowly than thin ink; therefore, thick ink requires a
    slow pen speed and pen point wider than 0.25 mm. Uneven lines can be caused
    by using ink too thick for the point. With thin ink, you can use narrow
    point sizes and faster plotting speeds. Here is some advice on drafting
    ink.
    
    *  Always keep ink bottles tightly closed when not in use.
    *  Do not mix different inks.
    *  Throw away ink that is more than one year old or contains sediment.
    *  Ink that works well in one climate may not do well in another. Ink
       dries faster in warm, dry conditions than in cool, moist environments.
       Ask your drafting supply dealer to recommend inks that are suited to
       your environment.
    *  Not all inks are compatible with all drafting media. Hewlett-Packard's
       drafting ink is suitable for most applications, but other types are
       available from drafting supply dealers.
    
    How Pen Speed Affects Line Quality
    
    Uniform lines result when a pen moves at the same rate as the ink flows;
    however, a plotter pen moves faster on long lines than on short lines. If
    your lines are thin in the middle and and thick or blotchy at the ends and
    corners, try a slower pen speed. Most HP plotters automatically select the
    optimum pen speed and force for you; but there may be times when you want
    to try a different speed or force.
    
    A slower pen speed makes line widths more uniform by reducing the inking
    variation between the center of a line and the end of the line, where the
    pen comes to rest. Reducing th pen speed also increases the ink density and
    definition throughout the line.
    
    Ink flow varies with several factors: the thickness of the ink, the pen
    speed, the diameter of the plotter point, and the surface of the drafting
    medium.  Experiment with the plot, varying one factor at a time, until you
    find the optimum combination.

    How to Change Pen Speed
    
    On many HP plotters you can change the speed from the front panel. Or, if
    you are using a graphics software package, it may allow you to specify
    whether you want to plot on paper or transparency film: select
    'transparency' to obtain a slow pen speed. If you are programming your
    plotter, use the the HP-GL velocity select (VS) instruction to slow the
    speed to 15 or even 10 cm/s.
    
    Keep Media Clean
    
    Cleanliness is important: skin oil, hand lotion, and other agents repel
    ink; and dust clogs pen tips. Keep drafting media packaged until you're
    ready to plot, and handle the sheets along the edges.
    
    Keep Pens Clean
    
    Drafting pens must be clean in order to write well; in fact, a dirty pen is
    the most common reason for poor results. If lines are uneven or the pen
    skips, dried ink may be blocking the tip or the air vent. Clean refillable
    drafting pens immediately after each use. If you use refillable drafting
    pens frequently, an ultrasonic pen cleaner is a necessity.

    What Is Accuracy?
    ----------------
    
    Accuracy error is the difference between the distance you specify, and the
    actual plotted distance.
    
    Accuracy can be specified and measured; but small errors in line length are
    usually invisible to the unaided eye and do not affect the apparent quality
    of the plot. Accuracy is important if measurements are to be taken from a
    plot, or if it is used to produce overlays, such as integrated circuit
    masks.
    
    How HP Specifies Accuracy
    
    Hewlett-Packard defines accuracy as the maximum error in the distance
    between two plotted endpoints. In the following illustration, if AB is the
    line length you want; the actual line length can vary within the radius of
    specified accuracy (e.g., AC).
    
    Some Sample Specifications
    
    Accuracy specifications for some HP drafting plotters are given below: HP
    DraftMaster (HP 7595, 7596) 0.25 mm or 0.09 percent of the move length,
    whichever is greater.  HP DraftPro (HP 7570) 0.5 mm or 0.2 percent of the
    move length, whichever is greater.
    
    Why Accuracy Is Specified as the Greater of Two Values
    
    The Hewlett-Packard plotter accuracy specification governs the variation in
    the distance between two endpoints. This specification is influenced by
    line length.
    
    On short lines, accuracy is affected most by the plotter's repeatability.
    For example, a 1 mm line cannot be drawn on a 0.1 mm repeatable plotter
    with better than 0.1/1 1[1 10 percent accuracy.
    
    On long lines, positioning errors due to imperfections in the straightness,
    parallelism, orthogonality and pitch radii of mechanical elements begin to
    dominate. These errors tend to be proportional to line length.
    
    Accuracy is therefore specified as the greater of two values: one constant,
    and one proportional to line length.
    
    Conditions of Warranty
    
    HP warrants its accuracy specification under the following plotting
    conditions:
    
    *  The plot is prepared on 3-mil double-matte polyester film.
    *  Room temperature is between 18[O] and 30[O] C (64[O] and 86[O] F)
       during plotting.
    *  The same pen is used for the entire plot.
    *  The plotter operates on a flat floor surface.
    *  On the DraftMaster II (HP 7596), plot length is limited to the
       maximum single frame size.

    How HP Measures Accuracy
    
    HP uses the following procedure to measure accuracy of a plotter.
    
    1. Under controlled environmental conditions, a rectangular array of 25
       targets is plotted by one pen on the largest sheet of double-matte paper
       for that plotter.
    2. A coordinate measuring machine, traceable to the National Bureau of
       Standards, records the actual plotted coordinates of each target.
    3. Actual distances between each of the 300 pairs of points are compared
       with their nominal values.
    4. Line length errors are graphed versus specified distance, as shown below
       for one plotter.

    How to Get the Best Accuracy
    ----------------------------
    
    Use the Right Medium
    
    Use Hewlett-Packard 3-mil double-matte polyester film for precise grit
    wheel movement and dimensional stability.
    
    *  Use Polyester Film
    
       Although it is the most expensive plotting media, polyester film is
       recommended for maximum accuracy. It is extremely durable and
       translucent, making it the medium of choice for close-tolerance
       applications, overlays, and master copies that require frequent
       modification or handling.  And most important for accuracy purposes,
       polyester film is dimensionally stable in temperature and humidity
       changes. In fact, film is about 10 times more dimensionally stable than
       paper. Paper changes more in one direction than the other as humidity
       cycles up or down. For example, paper can expand or contract up to 2
       percent in the cross machine direction; for an A0/E-size sheet, that's
       equivalent to a change of 17.3 mm (0.68 inch) in width.
    
    *  Use 3-mil Film Thickness
    
       Media thickness affects the distance the sheet moves with each rotation
       of the grit wheel. Film thicker than 3-mil increases the distance the
       sheet moves: lines become longer than specified. Film thinner than 3-mil
       decreases the distance the sheet moves: lines become shorter than
       specified.
    
    *  Use a Double-Matte Surface
    
       HP supplies a drafting film coated on both sides (double matte) with
       fine, rounded silica particles. The coating assures sharp line edges,
       maximum line density, and minimum pen abrasion. If you must use another
       brand of film, avoid those that have very abrasive surfaces because they
       wear down pen points rapidly.
    
       A double-matte surface is best for drafting plotters because it reduces
       the static charge which can build up between the platen and a slick
       surface. A static charge makes it harder for the plotter to move the
       medium, which can affect both line quality and accuracy.
    
    Control the Environment
    
    Changes in temperature or relative humidity cause the media to stretch or
    shrink. This stretching or shrinking occurs more in one dimension than the
    other. Despite its dimensional stability, even polyester film stretches or
    shrinks slightly with changes in temperature and humidity. You can minimize
    environmental effects in the following ways.
    
    *  Draw and Use Plots in the Same Environment
    
       Make and use your drawings within the same temperature range ---
       ideally, 10[O] and 30[O] C (50[O] and 86[O] F).

    *  Acclimate the Medium
    
       Temperature and humidity changes during the course of a plot can cause
       misregistered lines. Let the plotting media acclimate to the room in
       which the plotter is located before beginning to plot. About 30 minutes
       is sufficient.
    
    Minimize Pen Effects
    
    A perfect pen has a tip centered with its body, no out-of-roundness in its
    shaft, and draws a line with the same defined width at all speeds.
    Hewlett-Packard strives for perfection in pens; but there will always be
    small differences between pens. To minimize pen effects:
    
    *  Use the Same Pen
    
       By using only one pen, you can avoid variations in diameter among pens.
       Using additional pens can add an error of up to 0.15 mm per pen.
    
    *  Keep the Pen in the Holder
    
       Don't return the pen to the carousel until the plot is completed.
       Eccentricity between the shaft and tip causes errors when the pen is
       returned to the carousel and then picked up again because the pen has a
       different orientation each time. Reselecting a pen can add errors of up
       to 0.15 mm.
    
    Keep the Floor Flat
    
    A warped floor distorts the plotting mechanism of a drafting plotter.
    
    Reduce Programming Effects
    
    *  Avoid Using Plot Relative (PR) Instructions
    
       The HP-GL scale (SC) command lets you create your own user units. Of
       course, you can also scale from your host computer; but roundoff errors
       accumulate if you use the plot relative (PR) instruction with host
       scaling.  In the PR instruction, the plotter rounds off the fractional
       part of nonintger coordinates. Roundoff errors accumulate because each
       PR move is calculated relative to the most recent pen position.
       Therefore, when host scaling, use the plot absolute (PA) instruction,
       which references each move from the origin.
    
    *  Use Exact Conversion for Plotter Units
    
       When accuracy is crucial, use the exact length of a plotter unit (0.025
       mm or 0.0009843 inch). In other words, a plotter unit (0.025 mm) is not
       exactly equal to 0.001 inch; it is more accurately equal to 0.0009843
       inch.
    
    Prevent Media Slippage
    
    Grit-covered wheels move the plotting sheet back and forth. Some media,
    such as vellum or glossy paper, shed particles which collect on the wheels
    and eventually cause slipping.

    Clean the grit wheels regularly with the soft brush provided with the
    plotter.  Do not use a brush which is not specifically made for your
    plotter. If you do not have a brush, use compressed air.
    
    Media that are too thick, too thin, or too slippery may not be gripped
    properly as they move through the rollers. For the best results, use 3 mil
    polyester film.
    
    Limit Plot Length
    
    Although the DraftMaster II roll-feed plotter can draw plots several frames
    long, the accuracy specification is limited to plots drawn within a single
    frame. This limit was established because extensive equipment is required
    to verify accuracy on longer plots. (A frame is a single standard media
    size: A4/A through A0/E).
    
    Laboratory tests show that plotters calibrated for a single frame are
    accurate to three frames. Beyond three frames, media limitations affect
    accuracy: even the highest quality film can have a curvature as much as 1
    foot over a 100 foot length.
    
    How to Make Accurate Overlays
    
    Accuracy errors can become noticeable when one drawing overlays another. To
    produce accurate overlays, use the same rules as described above for
    producing accurate drawings. In addition:
    
    *  Use the Same Plotter
    
       Use one plotter for all overlays in a set. Because each plotter has
       unique accuracy characteristics, interchanging plotters can cause
       alignment errors of up to two times the specification.
    
    *  Use the Same Medium
    
       Use the same type and thickness of film for all overlays in a set.
    
    *  Use the Same Temperature and Humidity
    
       Make the set of overlays at similar temperature and humidity conditions.
    
    When to Recalibrate
    
    HP drafting plotters have correction constants set at the factory.
    Normally, this calibration lasts for the life of the plotter. Some HP
    plotters offer the capability to recalibrate in the field (see the user's
    guide). However, recalibration is advisable only if the plotter has been
    subjected to unusually severe conditions, such as the following:
    
    *  The physical hardware has changed
    
       For example, recalibrate if the grit wheel assembly or pinch wheel has
       been replaced.
    
    *  The plotter undergoes physical stress
    
       For example, if the plotter is severely bumped, or rolled over a rough
       surface, or transported without a packing crate, its physical
       characteristics may be altered enough to require recalibration.

    *  The plotting environment differs from the calibration environment
    
       The original calibration constants were calculated under specific
       environmental conditions (e.g., flat floor surface, room temperature
       equals 10[O] to 30[O] C). If environmental conditions have changed
       significantly since the last calibration, you may need to recalibrate to
       maintain specified accuracy.
    
    
    (11)5954-7132 March 1987
    Application Note 350-4 Printed in U.S.A.
    
